<?php
// Include the mail system configuration first to avoid header issues
require_once 'unified_config.php';

// Test email address
$TEST_EMAIL = 'sagarnandal95@gmail.com';
$TEST_NAME = 'Sagar Nandal';
?>
<!DOCTYPE html>
<html>
<head>
    <title>📧 ZForex Mail System - All Templates Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1, h2, h3 { color: #333; }
        .test-result { padding: 15px; margin: 15px 0; border-radius: 5px; }
        .success { background: #d4edda; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; border-left: 4px solid #ffc107; }
        .info { background: #d1ecf1; border-left: 4px solid #17a2b8; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 4px; overflow-x: auto; }
        .summary { background: #e7f3ff; padding: 20px; border-radius: 8px; margin: 20px 0; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f2f2f2; }
        .passed { color: #28a745; font-weight: bold; }
        .failed { color: #dc3545; font-weight: bold; }
    </style>
</head>
<body>
<div class='container'>
<h1>📧 ZForex Mail System - All Templates Test</h1>

<div class='info'>
    <h3>Testing Information</h3>
    <p><strong>Email:</strong> <?php echo $TEST_EMAIL; ?></p>
    <p><strong>Name:</strong> <?php echo $TEST_NAME; ?></p>
    <p><strong>Status:</strong> Running tests for all 22 email templates...</p>
</div>

<?php
// Get mail system instance
$mailSystem = getMailSystem();

// Test results array
$testResults = [];
$testCount = 0;
$successCount = 0;

// Test all 22 templates
$tests = [
    // 1. Register Verification
    'register_verification' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendRegisterVerification($TEST_EMAIL, $TEST_NAME, 'VER123456', '24 hours');
    },
    
    // 2. After Verify Credentials
    'after_verify_credentials' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendAfterVerifyCredentials($TEST_EMAIL, $TEST_NAME, 'USR789012');
    },
    
    // 3. Login Alert
    'login_alert' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendLoginAlert($TEST_EMAIL, $TEST_NAME, '192.168.1.100', 'Chrome on Windows');
    },
    
    // 4. Live Account Opened
    'open_live_account' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendLiveAccountOpened($TEST_EMAIL, $TEST_NAME, 'ACC123456789', 'Standard', '100', 'USD');
    },
    
    // 5. KYC Upload
    'kyc_upload' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendKYCUpload($TEST_EMAIL, $TEST_NAME, 'KYC987654', 'ID Document, Address Proof');
    },
    
    // 6. KYC Approved
    'kyc_approved' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendKYCApproved($TEST_EMAIL, $TEST_NAME, 'Full', 'September 30, 2025');
    },
    
    // 7. Deposit Request Submitted
    'deposit_request_submitted' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendDepositRequestSubmitted($TEST_EMAIL, $TEST_NAME, 1000, 'USD', 'Bank Transfer', 'DEP123456');
    },
    
    // 8. Deposit Approved
    'deposit_approved' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendDepositApproved($TEST_EMAIL, $TEST_NAME, 1000, 'USD', 5000, 'TXN789012');
    },
    
    // 9. Deposit Failed
    'deposit_failed' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendDepositFailed($TEST_EMAIL, $TEST_NAME, 500, 'USD', 'Insufficient funds', 'DEP345678');
    },
    
    // 10. Withdrawal OTP
    'otp_withdrawal' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendWithdrawalOTP($TEST_EMAIL, $TEST_NAME, '987654', 500, 'USD', 'Bank Account ****1234', '10 minutes');
    },
    
    // 11. Withdrawal Request Submitted
    'withdrawal_request_submitted' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendWithdrawalRequestSubmitted($TEST_EMAIL, $TEST_NAME, 500, 'USD', 'Bank Transfer', 'WTH123456');
    },
    
    // 12. Withdrawal Approved
    'withdrawal_approved' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendWithdrawalApproved($TEST_EMAIL, $TEST_NAME, 500, 'USD', 'TXN987654', '2-3 business days', 4500);
    },
    
    // 13. Withdrawal Rejected
    'withdrawal_rejected' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendWithdrawalRejected($TEST_EMAIL, $TEST_NAME, 500, 'USD', 'Invalid bank details', 'WTH789012');
    },
    
    // 14. IB Commission Withdrawal
    'ib_commission_withdrawal' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendIBCommissionWithdrawal($TEST_EMAIL, $TEST_NAME, 150, 'USD', 'September 2025', 5);
    },
    
    // 15. Referral Registration
    'referral_registration' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendReferralRegistration($TEST_EMAIL, $TEST_NAME, 'John Smith', '5');
    },
    
    // 16. Trade Opened
    'trade_opened' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendTradeOpened($TEST_EMAIL, $TEST_NAME, 'EUR/USD', 'BUY', '0.1', '1.0850');
    },
    
    // 17. Trade Closed
    'trade_closed' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendTradeClosed($TEST_EMAIL, $TEST_NAME, 'EUR/USD', '0.1', '1.0800', '1.0900', 10.50, 'USD', '2 hours');
    },
    
    // 18. Daily Trade Summary
    'daily_trade_summary' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendDailyTradeSummary($TEST_EMAIL, $TEST_NAME, 'September 30, 2025', 15, 10, 5, 125.75, 'USD', 5125.75);
    },
    
    // 19. Password Reset
    'password_reset' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendPasswordReset($TEST_EMAIL, $TEST_NAME, 'RESET123456', '1 hour');
    },
    
    // 20. Password Changed
    'password_changed' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendPasswordChanged($TEST_EMAIL, $TEST_NAME, '192.168.1.100');
    },
    
    // 21. Profile Updated
    'profile_updated' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendProfileUpdated($TEST_EMAIL, $TEST_NAME, 'Email, Phone Number');
    },
    
    // 22. Monthly Statement
    'monthly_statement' => function() use ($mailSystem, $TEST_EMAIL, $TEST_NAME) {
        return $mailSystem->sendMonthlyStatement($TEST_EMAIL, $TEST_NAME, 'September', '2025', 125, 567.89, 'USD', 10000, 5000, 15678.89);
    }
];

echo "<h2>🧪 Running Tests for All 22 Email Templates</h2>";

// Run all tests
foreach ($tests as $templateName => $testFunction) {
    $testCount++;
    echo "<h3>Test $testCount: $templateName</h3>";
    
    try {
        $result = $testFunction();
        $testResults[$templateName] = $result;
        
        if ($result['success']) {
            $successCount++;
            echo "<div class='test-result success'>";
            echo "<strong>✅ PASSED</strong><br>";
            echo "<em>Message:</em> " . htmlspecialchars($result['message']);
            echo "</div>";
        } else {
            echo "<div class='test-result error'>";
            echo "<strong>❌ FAILED</strong><br>";
            echo "<em>Error:</em> " . htmlspecialchars($result['message']);
            echo "</div>";
        }
    } catch (Exception $e) {
        $testResults[$templateName] = ['success' => false, 'message' => $e->getMessage()];
        echo "<div class='test-result error'>";
        echo "<strong>❌ EXCEPTION</strong><br>";
        echo "<em>Error:</em> " . htmlspecialchars($e->getMessage());
        echo "</div>";
    }
    
    // Add a small delay between emails
    sleep(1);
}

// Summary
echo "<div class='summary'>";
echo "<h2>📊 Test Summary</h2>";
echo "<table>
    <tr>
        <th>Template Name</th>
        <th>Status</th>
        <th>Message</th>
    </tr>";

foreach ($testResults as $templateName => $result) {
    $status = $result['success'] ? 'PASSED' : 'FAILED';
    $statusClass = $result['success'] ? 'passed' : 'failed';
    $message = htmlspecialchars($result['message']);
    
    echo "<tr>
        <td>" . htmlspecialchars($templateName) . "</td>
        <td class='$statusClass'>$status</td>
        <td>$message</td>
    </tr>";
}

echo "</table>";

$successRate = ($testCount > 0) ? round(($successCount / $testCount) * 100, 2) : 0;

echo "<div style='margin-top: 20px;'>
    <p><strong>Total Tests:</strong> $testCount</p>
    <p><strong>Successful:</strong> $successCount</p>
    <p><strong>Failed:</strong> " . ($testCount - $successCount) . "</p>
    <p><strong>Success Rate:</strong> {$successRate}%</p>
</div>";

echo "</div>";

echo "<div class='info'>
    <h3>📧 Next Steps</h3>
    <p>Please check your email inbox at <strong>$TEST_EMAIL</strong> to verify that all emails were delivered successfully.</p>
    <p>If any emails failed to send, check the error messages above and verify your mail configuration in <code>unified_config.php</code>.</p>
</div>";

echo "</div>
</body>
</html>"
?>