<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require "config.php";

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || empty($data['email'])) {
    echo json_encode(["success" => false, "message" => "Email is required"]);
    exit;
}

$email = $data['email'];

// Fetch referral code from database
$stmt = $conn->prepare("SELECT referalId FROM loginusers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($referralCode);
$stmt->fetch();

if ($referralCode) {
    echo json_encode(["success" => true, "email" => $email, "referralCode" => $referralCode]);
} else {
    echo json_encode(["success" => false, "message" => "User not found or referral code not set"]);
}

$stmt->close();
$conn->close();
?>
